# libpam is also installing /etc/environment and wins the race.  So let's append it here.

FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES_RDK', 'comcast-gperftools-heapcheck-wp', 'file://environment', '', d)}"

HEAPCHECK_WP_ENABLED = "${@bb.utils.contains('DISTRO_FEATURES_RDK', 'comcast-gperftools-heapcheck-wp', 'true', 'false', d)}"

do_install_append() {
   if [ "${HEAPCHECK_WP_ENABLED}" = "true" ]; then
      install -d ${D}${sysconfdir}
      install ${WORKDIR}/environment ${D}${sysconfdir}/environment
   fi
}

FILES_${PN} += "${@bb.utils.contains('DISTRO_FEATURES_RDK', 'comcast-gperftools-heapcheck-wp', '${sysconfdir}/environment', '', d)}"
